'use client'
import { useState } from "react";

const shortcuts = [
  { text: "new shortcut 3", type: "public" },
  { text: "other shortcut", type: "private" },
  { text: "hi", type: "public" },
  { text: "how are you", type: "private" },
  { text: "well", type: "public" }
];

const ShortcutSuggestions = ({ input }) => {
  const filteredShortcuts = shortcuts.filter(s =>
    s.text.toLowerCase().includes(input.toLowerCase())
  );

  return (
    <ul className="suggestion-box">
      {filteredShortcuts.map((shortcut, index) => (
        <li key={index} className="shortcut-item">
          {shortcut.type === "public" ? "📢" : "🔒"} {shortcut.text}
        </li>
      ))}
    </ul>
  );
};

const ChatInput = () => {
  const [input, setInput] = useState("");

  return (
    <div className="chat-container">
      <input
        type="text"
        value={input}
        onChange={(e) => setInput(e.target.value)}
        placeholder="Type a message..."
      />
      {input && <ShortcutSuggestions input={input} />}
    </div>
  );
};

export default ChatInput;
