'use client';

import React, { useEffect, useState } from 'react';
import './css/login.css';
import { useRouter } from 'next/navigation';
import { getCookie, setCookie } from 'cookies-next';
import { useDispatch, useSelector } from 'react-redux';
import { verifyUserRole } from './lib/features/user/UserSlice';
import { reset } from './lib/features/chat/chatSlice';
import LoadingSpinner from './LoadingSpinner';
 
import LoginImage from '@/public/assets/images/loginimage.png'
import './login/login.css'
import './login/main.css'
import getDeviceId from './hooks/useVisitorId';
const Login = () => {
  const [email, setEmail] = useState('');
  const [password, setPassword] = useState('');
  const [error, setError] = useState('');
  const [isLoading, setIsLoading] = useState(true);
  const router = useRouter();
  const dispatch = useDispatch();
  const apiUrl = process.env.NEXT_PUBLIC_API_URL;
  const status = useSelector((state) => state.user.status);
  const token = getCookie('token');
  const user = useSelector((state) => state.user.userInfo);
  const [deviceId, setdeviceId] = useState()
 
  useEffect(() => {
    if (token) {
      if (user.length > 0) {
        routeUser(user.role);
        setIsLoading(false);
      } else {
        setIsLoading(true);
        dispatch(verifyUserRole(token)).then((userData) => {
          if (userData.payload) {
            routeUser(userData.payload.role);
            // setIsLoading(false);
          }
        });
      }
    } else {
      setIsLoading(false);
      localStorage.clear();
      dispatch(reset());
    }
  }, []);

  const routeUser = (role) => {
    if (role === 1) {
      router.push('/company-management');
    } else if (role === 2) {
      router.push('/brands');
    } else {
      router.push('/chat');
    }
  };

  const handleSubmit = async (e) => {
    e.preventDefault();
    setIsLoading(true);
    const device_id = await getDeviceId();

    try {
      
        const response = await fetch(`${apiUrl}/api/auth/login`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ email, password, device_id }),
        });

        if (response.ok) {
            const { accessToken, refreshToken } = await response.json();
            

            const options = {
              httpOnly: false, // Do not use httpOnly because it needs to be accessible in JavaScript
              // secure:true,
              sameSite: 'strict', // Necessary for cross-site requests (Important for cross-origin)
              path: '/', // Cookies available throughout the site
              maxAge: 60 * 60 * 24, // Set a suitable expiration for accessToken (1 day)
            };
          
            // Set access token and refresh token
            setCookie('token', accessToken, { ...options  });
            setCookie('refreshToken', refreshToken, { ...options });
            

            dispatch(verifyUserRole(accessToken)).then((userData) => {
                if (userData.payload) routeUser(userData.payload.role);
               
            });
        } else {
            const data = await response.json();
            setIsLoading(false);
            setError(data.message || 'Something went wrong');
        }
    } catch (err) {
        setError('Failed to log in');
        
    } finally {
      
    }
};


  if (isLoading) {
    return <LoadingSpinner />;
  }

  return (
    <div className="limiter d-flex justify-content-center align-items-center min-vh-100">
  <div className="container-login100">
    <div className="wrap-login100 shadow">
      <div className="login100-pic js-tilt" data-tilt>
        <img src={LoginImage.src} alt="IMG" />
      </div>

      <form className="login100-form validate-form" onSubmit={handleSubmit}>
        <span className="login100-form-title">Member Login</span>

        {error && <div className="alert alert-danger p-1 py-2 px-2">{error}</div>}

        <div className="wrap-input100 validate-input mb-3" data-validate="Valid email is required: ex@abc.xyz">
          <input
            className=" form-control input100"
            type="text"
            name="email"
            placeholder="Email"
            value={email}
            onChange={(e) => setEmail(e.target.value)}
          />
          <span className="focus-input100"></span>
          <span className="symbol-input100">
            <i className="fa fa-envelope" aria-hidden="true"></i>
          </span>
        </div>

        <div className="wrap-input100 validate-input mb-3" data-validate="Password is required">
          <input
            className="form-control input100 "
            type="password"
            name="pass"
            placeholder="Password"
            value={password}
            onChange={(e) => setPassword(e.target.value)}
          />
          <span className="focus-input100"></span>
          <span className="symbol-input100">
            <i className="fa fa-lock" aria-hidden="true"></i>
          </span>
        </div>

        <div className="container-login100-form-btn">
          <button className="login100-form-btn btn btn-primary w-100 mt-3">Login</button>
        </div>
      </form>
    </div>
  </div>
</div>

  );
};

export default Login;
