'use client'
import { createSlice } from '@reduxjs/toolkit';

let savedTabs ;
if(typeof window !== 'undefined'){
  // now access your localStorage
  savedTabs = JSON.parse(localStorage.getItem('chatTabs')) || [];
 
}
const chatSlice = createSlice({
  name: 'chat',
  initialState: {
    tabs: savedTabs, 
    activeTab: savedTabs?.length > 0 ? savedTabs.find(tab => !tab.minimized)?.client_id || null : null,
  },
  reducers: {
    addTab: (state, action) => {
      const newTab = action.payload;
      
      const existingTab = state.tabs.find((tab) => tab.client_id === newTab.client_id);

      if (!existingTab) {
        state.tabs.push({
          client_id: newTab.client_id,
          minimized: false,
          visitorStatus: newTab.visitorStatus,
          visitor_session_id: newTab.visitor_session_id,
          public_key: newTab.public_key,
          blinking: false, // New tab starts without blinking
          servedBy:newTab.servedBy,
          name:newTab.name ? newTab.name : null
        });
        state.activeTab = newTab.client_id;
        localStorage.setItem('chatTabs', JSON.stringify(state.tabs));
      } else {
        state.activeTab = existingTab.client_id;
        existingTab.minimized = false;
        existingTab.blinking = false; // Stop blinking if tab is activated
      }

      localStorage.setItem('chatTabs', JSON.stringify(state.tabs));
    },
    closeTab: (state, action) => {
      const { client_id } = action.payload;
      state.tabs = state.tabs.filter((tab) => tab.client_id !== client_id);
      if (state.activeTab === client_id) {
        state.activeTab = state.tabs.find(tab => !tab.minimized)?.client_id || null;
      }
      localStorage.setItem('chatTabs', JSON.stringify(state.tabs));
    },
    updateTabStatus: (state, action) => {
      const { client_id, status } = action.payload;
      const tab = state.tabs.find(tab => tab.client_id === client_id);
      if (tab) {
        tab.visitorStatus = status;
        localStorage.setItem('chatTabs', JSON.stringify(state.tabs));
      }
    }, updateTabVisitorSession: (state, action) => {
      const { client_id, visitor_session_id } = action.payload;
      const tab = state.tabs.find(tab => tab.client_id === client_id);
      if (tab) {
        tab.visitor_session_id = visitor_session_id;
        localStorage.setItem('chatTabs', JSON.stringify(state.tabs));
      }
    },
    updateTabServedBy: (state, action) => {
      const { client_id, servedBy } = action.payload;
      const tab = state.tabs.find(tab => tab.client_id === client_id);
      if (tab) {
        tab.servedBy = servedBy;
        localStorage.setItem('chatTabs', JSON.stringify(state.tabs));
      }
    },
    updateTabStatus: (state, action) => {
  const { client_id, status } = action.payload;
  const tab = state.tabs.find(tab => tab.client_id === client_id);
  if (tab) {
    tab.visitorStatus = status;
    localStorage.setItem('chatTabs', JSON.stringify(state.tabs));
  }
},
   // New action that combines the above updates
   updateTabDetails: (state, action) => {
    const { client_id, visitor_session_id, status, servedBy, name } = action.payload;
  
    state.tabs = state.tabs.map((tab) =>
      tab.client_id === client_id
        ? {
            ...tab,
            ...(visitor_session_id && { visitor_session_id }),
            ...(status && { visitorStatus: status }),
            ...(servedBy && { servedBy }),
            ...(name && { name }),
          }
        : tab
    );
  
    // Save updated tabs to local storage
    localStorage.setItem('chatTabs', JSON.stringify(state.tabs));
  },
  
  
 
    setActiveTab: (state, action) => {
      state.activeTab = action.payload;
     // Stop blinking when the tab becomes active
    },
    RemoveBlinkingFromTab: (state, action) => {
      
      const tab = state.tabs.find(tab => tab.client_id === action.payload);
      if (tab) tab.blinking = false; // Stop blinking when the tab becomes active
    },
    minimize: (state, action) => {
      const { client_id } = action.payload;
      const tab = state.tabs.find((tab) => tab.client_id === client_id);
      state.activeTab = null
      if (tab) {
        tab.minimized = true;
     
        if(state.activeTab == client_id){
        
        }
        state.activeTab = state.tabs.find(tab => !tab.minimized)?.client_id || null;
      }
      localStorage.setItem('chatTabs', JSON.stringify(state.tabs));
    },
    toggleMinimizeTab: (state, action) => {
      const { client_id } = action.payload;
      const tab = state.tabs.find((tab) => tab.client_id === client_id);
      const active = state.tabs.find((tab) => tab.client_id === state.activeTab);
      if (tab) {
        if (active && active.client_id !== tab.client_id) {
          active.minimized = true;
        }
        tab.minimized = !tab.minimized;
        if (!tab.minimized) {
          state.activeTab = client_id;
          tab.blinking = false; // Stop blinking when the tab is restored
        } else {
          state.activeTab = state.tabs.find(tab => !tab.minimized)?.client_id || null;
        }
        localStorage.setItem('chatTabs', JSON.stringify(state.tabs));
      }
    },
    setBlinkingTab: (state, action) => {
      const { client_id } = action.payload;
                        const tab = state.tabs.find(tab => tab.client_id === client_id);
            if(state.activeTab){
        if (tab && tab.client_id !== state.activeTab) {
          tab.blinking = true; // Set blinking if it's not the active tab
        }
      }
      else{
        if(tab){

          tab.blinking = true; // Set blinking if it's not the active tab
        }
      }
   
      localStorage.setItem('chatTabs', JSON.stringify(state.tabs));
    },

    reset: (state) => {
      state.tabs = [];
      state.activeTab = null;
    },
  },
});

export const { addTab, closeTab, setActiveTab, reset,updateTabDetails, updateTabStatus,updateTabServedBy,  updateTabVisitorSession, toggleMinimizeTab, minimize, setBlinkingTab,RemoveBlinkingFromTab } = chatSlice.actions;
export default chatSlice.reducer;
