'use client';
import { useState } from 'react';
import Shortcuts from './shortcurts';
import { useSelector } from 'react-redux';
import SoundSetting from './SoundSetting';
 

export default function ShortcutsPage() {
 
  const [activeTab, setActiveTab] = useState('tab1');
  const user = useSelector((state) => state.user.userInfo);
  
      return (
    <>
   
    <div className="container-fluid top-bar">
        <div className="left-div">
          <h2>Settings</h2>
        </div>
        <div className="right-div"></div>
        </div>
    <div className='settings-container'>

    
      {/* Tab Header */}
      <div className='container-fluid company-header'>
      <div className="settings-header comp-header-row">
        <button
          className={`settings-tab-button btn me-2 ${activeTab === 'tab1' ? 'active' : ''}`}
          onClick={() => setActiveTab('tab1')}
        >
         Shortcuts
        </button>
        <button
          className={`settings-tab-button btn me-2 ${activeTab === 'tab2' ? 'active' : ''}`}
          onClick={() => setActiveTab('tab2')}
        >
          Sounds
        </button>
      </div>
      </div>
      
      {/* Tab Content */}
      <div className="settings-tab-content">
        {activeTab === 'tab1' && (
          <div className="setting-tab-content">
            <h3>Manage Shortcuts</h3>
            <Shortcuts companyId={user?.company_id} userId={user?.userId} />
          </div>
        )}
        {activeTab === 'tab2' && (
          <div className="setting-tab-content">
            <h3>Manage tones</h3>
              <SoundSetting userId={user?.userId}/>
          </div>
        )}
      </div></div>
      </>
     
  );
}
