import React, { useState, useEffect } from "react";
import tones from "../data/allTones.json";
import { useDispatch, useSelector } from "react-redux";
import { saveTones, setMessageTone, setNotificationTone } from "@/app/lib/features/tones/tonesSlice";
import swal from 'sweetalert';
const SoundSetting = () => {
  const [audioPlayer, setAudioPlayer] = useState(null);
  const user = useSelector((state) => state.user.userInfo);
  // Accessing tones from Redux state
  const { newVisitorTone, messageTone, toneStatus } = useSelector(state => state.tones);
  const dispatch = useDispatch();

  // Set initial selected tones based on Redux state
  const [NewmessageTone, setNewMessageTone] = useState(messageTone || "");
  const [notificationTone, setNewNotificationTone] = useState(newVisitorTone || "");

  useEffect(() => {
    
    
    // Sync the state with Redux when the component loads or Redux state changes
    setNewMessageTone(messageTone || "");
    setNewNotificationTone(newVisitorTone || "");
  }, [messageTone, newVisitorTone]);

  const handlePlay = (file) => {
    if (audioPlayer) {
      audioPlayer.pause();
    }

    const audio = new Audio(`/sounds/${file}`);
    setAudioPlayer(audio);
    audio.play();
  };

  const handleSave = (selectedTone, toneType) => {
    // Update local state based on tone type
    if (toneType === 'message') {
      setNewMessageTone(selectedTone);
    } else if (toneType === 'notification') {
      setNewNotificationTone(selectedTone);
    } else {
      console.error('Invalid tone type:', toneType);
      return;
    }
  
    // Prepare request data
    const requestData = {
      user_id: user.userId, // Replace with the actual user ID from the state
      new_visitor_tone: toneType === 'notification' ? selectedTone.name : notificationTone.name,
      message_tone: toneType === 'message' ? selectedTone.name : NewmessageTone.name,
    };
  
    // Dispatch the async action
    dispatch(saveTones(requestData))
      .unwrap() // Handle the promise result
      .then(() => {
        
      })
      .catch((error) => {
        console.error('Error saving tones:', error);
      });
  
    // Update Redux state with new tones
    if (toneType === 'message') {
      dispatch(setMessageTone(selectedTone));
    } else if (toneType === 'notification') {
      dispatch(setNotificationTone(selectedTone));
    }
  };
  

  return (
    <div className="sound-container">
      <h1 className="sound-header">Sound Settings</h1>

      <table className="sound-table">
        <thead>
          <tr>
            <th>Tone Name</th>
            <th>Message Tone</th>
            <th>Notification Tone</th>
            <th>Play</th>
          </tr>
        </thead>
        <tbody>
          {tones.map((tone) => (
            <tr key={tone.file}>
              <td className="sound-toneName">{tone.name}</td>
              <td>
                <input
                  type="radio"
                  name="messageTone"
                  value={tone.file}
                  id={`message-${tone.file}`}
                  checked={NewmessageTone.file === tone.file}
                  onChange={() =>handleSave(tone,'message') }
                  className="sound-radioInput"
                />
              </td>
             
              <td>
                <input
                  type="radio"
                  name="notificationTone"
                  value={tone.file}
                  id={`notification-${tone.file}`}
                  checked={notificationTone.file === tone.file}
                  onChange={() =>handleSave(tone,'notification') }
                  className="sound-radioInput"
                />
              </td>
              <td>
                <button
                  className="sound-playButton"
                  onClick={() => handlePlay(tone.file)}
                >
                  ▶ Play
                </button>
              </td>
            </tr>
          ))}
        </tbody>
      </table>

     
    </div>
  );
};

export default SoundSetting;
