import React, { useState, useEffect, useRef, useCallback } from 'react';
import { FaArrowAltCircleRight } from 'react-icons/fa';
import { getSocket } from '@/app/lib/socketManager';
import { useDispatch, useSelector } from 'react-redux';
import swal from 'sweetalert';
import { MdBlock, MdCheckCircle } from 'react-icons/md';
import VisitorIpStats from '../VisitorIPstatus';
import VisitorManualIp from '../VisitorManualIp';
import axios from 'axios';
import { IoCloseSharp } from "react-icons/io5";
import apiRequest from '@/app/lib/InterceptorAxios/axios';

const HistoryChatMeta = ({  clientId,
  publicKey,
  currentChat,
  updateIpHealth,
  setHideColumns,
  setCurrentChat,  }) => {
    const user = useSelector((state) => state.user.userInfo);
 
  const socket = getSocket();
  const [VisitedUrl, setVisitedUrl] = useState([])
  const [MetadataV, setMetadataV]=useState()
  const { tabs, activeTab } = useSelector((state) => state.chat);
  const [isIpBlocked, setisIpBlocked] = useState(false)
  const [isClientBlocked, setisClientBlocked] = useState()
  const toastInterval = useRef(null);
  const [showToast, setShowToast] = useState(false);
  const dispatch = useDispatch();
  const intervalRef = useRef(null);
//   const joinTime = originalJoinTimes[clientId]; // Fetch original join time by clientId
  const [visitorData, setVisitorData] = useState({
    name: '',
    email: '',
    phone: '',
    notes: '',
    tags: [],
    tagInput: '', // To track the input while typing tags
  });
  // const [elapsedTime, setElapsedTime] = useState('0 mins');
 
 // Function to check and trim URL
 function checkAndTrimUrl(url) {
  // Remove 'http://', 'https://', or 'www.' from the beginning of the URL
  const trimmedUrl = url.replace(/^https?:\/\/|^www\./, '');

  // If the URL length exceeds 32 characters, trim and append '...'
  if (trimmedUrl.length > 32) {
    return trimmedUrl.substring(0, 32) + '...';
  }

  return trimmedUrl;
}

    // Fetch client data and handle socket events
    useEffect(() => {
      const fetchClientData = async () => {
        try {
          const data =await  apiRequest('/api/client/data','POST',{
            chatKey: `${currentChat?.public_key}_${currentChat?.client_id}`
          })
     
          const { name, email, phone, notes, tags } = data.client;
          setisClientBlocked(data.isClientBlocked)
          setisIpBlocked(data.isIpBlocked)
      
          
          setVisitorData({
            name: name || '',
            email: email || '',
            phone: phone || '',
            notes: notes || '',
            tags: tags || [],
            tagInput: '',
          });
          
          
        } catch (error) {
          console.error('Error fetching client data:', error);
        }
      };
  
      if (currentChat) {
        fetchClientData(); // Call the function to fetch data
      }
    }, [currentChat.visitor_session_id]);
  
 
    const fetchVisitedUrls = async () => {
      try {
        const data =await apiRequest('api/client/history/urls','POST', {
          visitor_session_id:currentChat.visitor_session_id,
          client_id:currentChat.client_id
        })
         
         
         
    
        
        const extractedUrls = data.urls.map((item) => item.url);
        setVisitedUrl(extractedUrls);
      } catch (error) {
        console.error('Error fetching visited URLs:', error);
      }
    };
     const fetchHistoryChatMetada = async () => {
      try {
        
        
        const data = await  apiRequest(`/api/client/client-metadata`,'POST',{
          visitor_id : currentChat?.visitor_session_id,
          client_id:clientId,
        } )
        setMetadataV(data)
        
        
        return data
      } catch (error) {
        console.error('Error fetching visitor metadata:', error);
      }
    };
    // Fetch visited URLs when the component mounts or `clientId` changes
    useEffect(() => {
      
  
      if (currentChat) {
        fetchVisitedUrls();
 fetchHistoryChatMetada() 
 


      }
    }, [currentChat.visitor_session_id]);
    // const calculateSessionTime = (joinTime, leftTime) => {
    //   const joinDate = new Date(joinTime);
    //   const leftDate = new Date(leftTime);
    
    //   // Calculate the difference in milliseconds
    //   const diffMs = leftDate - joinDate;
    
    //   // Convert milliseconds to hours, minutes, and seconds
    //   const hours = Math.floor(diffMs / (1000 * 60 * 60));
    //   const minutes = Math.floor((diffMs % (1000 * 60 * 60)) / (1000 * 60));
    //   const seconds = Math.floor((diffMs % (1000 * 60)) / 1000);
    //   if(hours > 0)
    //   {
    //     return `${hours}h ${minutes}m ${seconds}s`;
    //   }
    //   else if (minutes >0){
    //     return `  ${minutes}m ${seconds}s`;
    //   }
    //   else if (seconds >0){
    //     return `${seconds}s`;
    //   }
     
    // };
    const calculateSessionTime = (joinTime, leftTime) => {
      const joinDate = new Date(joinTime);
      const leftDate = new Date(leftTime);
      
      // Calculate the difference in milliseconds
      const diffMs = leftDate - joinDate;
    
      // Convert milliseconds to total minutes and seconds
      const totalMinutes = Math.floor(diffMs / (1000 * 60));
      const seconds = Math.floor((diffMs % (1000 * 60)) / 1000);
    
      // Display total minutes if greater than zero, otherwise display seconds
      if (totalMinutes > 0) {
        return `${totalMinutes} min`;
      } else {
        return `${seconds} sec`;
      }
    };
    
    const handleInputChange = (e) => {
      const { id, value } = e.target;
      setVisitorData((prevData) => ({
        ...prevData,
        [id]: value,
      }));
    };
  
    // Handle tag input and add new tag
    const handleTagInputChange = (e) => {
      const { value } = e.target;
      if (value.endsWith(', ') || e.key === 'Enter') {
        const newTag = value.trim().replace(',', '');
        if (newTag && !visitorData.tags.includes(newTag)) {
          setVisitorData((prevData) => ({
            ...prevData,
            tags: [...prevData.tags, newTag],
            tagInput: '',
          }));
        } else {
          setVisitorData((prevData) => ({
            ...prevData,
            tagInput: '',
          }));
        }
      } else {
        setVisitorData((prevData) => ({
          ...prevData,
          tagInput: value,
        }));
      }
    };
  
    // Handle key press for Enter in tag input
    const handleTagKeyPress = (e) => {
      if (e.key === 'Enter') {
        e.preventDefault();
        handleTagInputChange(e);
      }
    };
  
    // Remove tag
    const removeTag = (indexToRemove) => {
      setVisitorData((prevData) => ({
        ...prevData,
        tags: prevData.tags.filter((_, index) => index !== indexToRemove),
      }));
    };
  
    // Function to save notes and tags
    // const saveVisitorData = async () => {
    
    //   try {
    //     await axios-put(`${process.env.NEXT_PUBLIC_API_URL}/api/client/visitor-tag-notes-update`, {
    //       session_id: currentChat.chat_session_id,
    //       notes: visitorData.notes,
    //       tags: visitorData.tags
    //     });
    //     swal("Success!", "tags or Notes Updated", "success");
    //     // alert('Notes and tags updated successfully.');
    //   } catch (error) {
    //     console.error("Error updating notes and tags:", error);
    //     // alert('Failed to update notes and tags.');
    //   }
    // };
    const saveVisitorData = async () => {
      try {
        await apiRequest(`/api/client/visitor-tag-notes-update`,"PUT", {
          session_id: currentChat.chat_session_id,
          notes: visitorData.notes,
          tags: visitorData.tags
        });
        swal("Success!", "Tags or Notes Updated", "success");
      } catch (error) {
        console.error("Error updating notes and tags:", error);
      }
    };
function handleCopyAndOpen(url) {
  setShowToast(true);
  // event.stopPropagation(); // Prevent the click from bubbling up to the row
  navigator.clipboard.writeText(url)
    .then(() => {
      // Clear any existing interval to reset the timer
      if (toastInterval.current) {
        clearInterval(toastInterval.current);
      }

      // Set a new interval to hide the toast after 3 seconds
      toastInterval.current = setInterval(() => {
        setShowToast(false);
        clearInterval(toastInterval.current); // Clear interval after hiding toast
      }, 3000);
    })
    .catch(err => console.error('Failed to copy text: ', err));
}
const handleUpdateVisitorData = useCallback(() => {
  const updatedData = {
    ...visitorData,
    tags: visitorData.tags, 
  };
 
  socket.emit('update client data', {
    client_id: clientId,
    public_key: publicKey,
    ...updatedData,
  });

  
}, [visitorData, clientId, publicKey]);

  const handleMinimizeTab = (client_id) => {
    if (intervalRef.current) {
      clearInterval(intervalRef.current);
    }
     
  };
  const handleCloseChat = ()=>{
 
    setHideColumns(false)
    setCurrentChat(null)
  }

  return (
    <>
        {showToast && (
          <div className="toast show alert-success  " role="alert" aria-live="assertive" aria-atomic="true">
           
            <div className="alert alert-success alert-on-chat copy-visitor-url-history  " role='alert'>Copied to clipboard</div>
          </div>
        )}
 
    <div className="visitor-box-right">
      <div className='closed-chatbox-sidebar'  onClick={() => handleCloseChat()}><IoCloseSharp size={16}/></div>
      { 
      }
      <div className="client-details-box chat-visitor-item-3">
        <div className="input-group">
          <input
            type="text"
            id="name"
            className="visitor-name-input form-control"
            placeholder="Add Name"
            value={visitorData.name}
          
             
            disabled
          />
        </div>
        <div className="input-group">
          <input
            type="email"
            id="email"
            className="visitor-email-input form-control"
            placeholder="Add Email"
            value={visitorData.email}
          
            disabled
          />
        </div>
        <div className="input-group">
          <input
            type="tel"
            id="phone"
            className="visitor-phone-input form-control"
            placeholder="Add Phone Number"
            value={visitorData.phone}
           
            disabled
          />
        </div>
        <div>
      {/* Notes Input Section */}
      <div className="input-group">
        <textarea
          id="notes"
          className="visitor-notes-textarea form-control"
          rows="3"
          placeholder="Add Visitor Notes"
          value={visitorData.notes}
          onChange={handleInputChange}
        ></textarea>
      </div>

      {/* Tag Input Section */}
      <div className="input-group d-flex flex-column">
        <label htmlFor="tags" style={{ fontSize: '13px' }}>Tags:</label>
        <div className="tags-input-container">
          <div className={`tags-box-container ${visitorData.tags.length ? 'active' : ''}`}>
            {visitorData.tags.map((tag, index) => (
              <div className="tag-item" key={index}>
                <span className="tag-text">{tag}</span>
                <span className="tag-remove" onClick={() => removeTag(index)}>
                  &times;
                </span>
              </div>
            ))}
          </div>
          <input
            type="text"
            id="tagInput"
            className="visitor-tags-input form-control w-100"
            placeholder="Add Tags (comma + space or enter to create)"
            value={visitorData.tagInput}
            onChange={handleTagInputChange}
            onKeyPress={handleTagKeyPress}
          />
        </div>
      </div>

{/* Save Button */}
{/* Save Button */}
{((Array.isArray(visitorData.tags) && visitorData.tags.length > 0) || visitorData.notes) && (
    <button onClick={saveVisitorData} className="mt-3 btn btn-secondary visitor-tags-updated-btns">
        Save
    </button>
)}


    </div>
      </div>
 {/* Client Visit Stats Box */}
 <div className="client-visit-stats-box chat-visitor-item-4">
        <div className="client-stats-head">
          <div className="past-visits-stats chat-stats">
            <p>{MetadataV?.total_visitor_sessions}</p>
            <span>Past Visits</span>
          </div>
          <div className="past-chats-stats chat-stats">
            <p>{MetadataV?.total_chat_sessions}</p>
            <span>Past Chats</span>
          </div>
       
          <div className="past-timing-stats chat-stats">
          <p >{calculateSessionTime(currentChat.join_time, currentChat.left_time)}</p>
          <span>Time on site</span>
        </div>
      </div>
        <div className="visitor-path-history mt-3" style={{ background: '#fff' }}>
          <h4 style={{ fontSize: '17px', fontWeight: 'bold' }}>Visitor Path</h4>
          <div className="visitor-path-list">
          <ul>
      {VisitedUrl?.slice().reverse().map((url, index) => (
        <li key={index}>
          <FaArrowAltCircleRight className="me-2" style={{ color: '#72BE9E' }} />
          <a 
            href={url} 
            target='_blank' 
            className='visitor-url-chat' 
            onClick={(e) => {
              e.preventDefault();
              handleCopyAndOpen(url);
            }}
            title={url} 
          >
            {checkAndTrimUrl(url)}
          </a>
        </li>
      ))}
    </ul>
   
          </div>
        </div>
        <div className="visitor-details-ip">
        <div className="visitor-ip-stats" >
        <VisitorManualIp
        visitorSessionId={currentChat?.visitor_session_id}
        ipHealth={currentChat?.IP_Health} // Pass the correct IP health from currentChat
        updateIpHealth={updateIpHealth} // Pass updateIpHealth down
      />
          </div>
        <VisitorIpStats isClientBlocked={isClientBlocked} isIpBlocked={isIpBlocked} clientId={clientId} ip={MetadataV?.ip} pseudonym ={user.pseudonym} socket={socket} public_key={publicKey}/>
          <div className="visitor-location visitor-extra-stats">
            <span>Location: </span>
            <p>
  {MetadataV?.country}
  {MetadataV?.city && MetadataV.city !== 'Unknown' ? `, ${MetadataV.city}` : ''}
</p>

          </div> 
          <div className="visitor-location visitor-extra-stats">
            <span>IP: </span>
            <p>{MetadataV?.ip} </p>
          </div>
          <div className="visitor-browser visitor-extra-stats">
            <span>Browser: </span>
            <p>{MetadataV?.browser}</p>
          </div>
          <div className="visitor-os visitor-extra-stats">
            <span>OS: </span>
            <p>{MetadataV?.os}</p>
          </div>
        </div>
      </div>

      {/* Visitor History Box */}
      <div className="visitor-history-box chat-visitor-item-5">
        {/* Add Visitor History content */}
      </div>
      {/* Remaining UI Components */}
    </div>
    </>
  );
};

export default HistoryChatMeta;
