"use client";
import { useState, useEffect, useCallback, useMemo, useRef } from "react";

import { useDispatch, useSelector } from "react-redux";

import { getCookie } from "cookies-next";
import { getSocket } from "@/app/lib/socketManager";
import { useParams } from "next/navigation";
import { countryNameToCode } from "@/app/countries";
import windows from "@/public/assets/images/windows.png";
import Ios from "@/public/assets/images/apple.png";
import chrome from "@/public/assets/images/chrome.png";
import firefox from "@/public/assets/images/firefox-icon.png";
import edge from "@/public/assets/images/edge.png";
import safari from "@/public/assets/images/safari-icon.png";

import ubunto from "@/public/assets/images/ubunto.png";
import android from "@/public/assets/images/android.png";
import notificationSound from "@/public/sounds/chatalert.mp3";
import { addTab, minimize } from "../../lib/features/chat/chatSlice";
import FilterChats from "./FilterChats";
import axios from "axios";
import apiRequest from "@/app/lib/InterceptorAxios/axios";
import { decryptData } from "@/app/utils/DecryptData";
const Chat = () => {
  const [showToast, setShowToast] = useState(false);
  const [socket, setSocket] = useState(null);
  const [messages, setMessages] = useState([]);
  const [newMessage, setNewMessage] = useState("");
  const [currentChat, setCurrentChat] = useState(null);
  const [visitors, setVisitors] = useState([]);
  const [hideColumns, setHideColumns] = useState(false);
  const [blinkingVisitor, setBlinkingVisitor] = useState([]);
  const {  activeTab } = useSelector((state) => state.chat);
  const [IsShowPK, setIsShowPK] = useState(false);
  const [ShowAlert, setShowAlert] = useState(false);
  const [showFilter, setShowFilter] = useState(false);
  const selectedBrands = useSelector((state) => state.selectedBrands.selectedBrands);
  const [filteredVisitors, setFilteredVisitors] = useState([]);
 
  const [brands, setBrands] = useState([]);
  const [filteredBrand, setFilteredBrand] = useState([]);
  const toggleFilterChats = () => {
    setShowFilter((prev) => !prev);
  };
  const dispatch = useDispatch();
  // New state to track which row should blink

  const user = useSelector((state) => state.user.userInfo);
  //   const toastInterval = useRef(null);
  const { bid } = useParams();

  const copyVisitorId = (client_id, event) => {
    setShowToast(true);
    event.stopPropagation(); // Prevent the click from bubbling up to the row
    navigator.clipboard
      .writeText(client_id)
      .then(() => {
        // Clear any existing interval to reset the timer
        if (toastInterval.current) {
          clearInterval(toastInterval.current);
        }

        // Set a new interval to hide the toast after 3 seconds
        toastInterval.current = setInterval(() => {
          setShowToast(false);
          clearInterval(toastInterval.current); // Clear interval after hiding toast
        }, 3000);
      })
      .catch((err) => console.error("Failed to copy text: ", err));
  };
  const [originalJoinTimes, setOriginalJoinTimes] = useState({});
  const token = getCookie("token");
  function emitTimeInUserTimezone(serverTime) {
    // Parse the server time (ISO format in UTC)
    const serverUtcTime = new Date(serverTime); // ISO string will be handled as UTC automatically

    // Get the user's local time zone (e.g., 'Asia/Karachi')
    const userTimezone = Intl.DateTimeFormat().resolvedOptions().timeZone;

    // Format the server time into the user's local time zone
    const userLocalTime = new Intl.DateTimeFormat("en-US", {
      timeZone: userTimezone,
      year: "numeric",
      month: "2-digit",
      day: "2-digit",
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit",
      hour12: true, // Change to false for 24-hour format if desired
    }).format(serverUtcTime);
 
    return userLocalTime;
  }

  //if currentchat.clientid != recievedchat.clientid ? 'make sound alert':'no action'
  //client send message > chat is not opened > it's not seen > make sound
  //client send message > ...............> show blinking
  //..................  > chat is seen and then closed > don't show blinking
  const removeBlinkingVisitor = (clientId) => {
    setBlinkingVisitor((prevBlinkingVisitors) => {
      // Filter out the specific clientId
      return prevBlinkingVisitors.filter((id) => id !== clientId);
    });
  };
  useEffect(() => {
    // const fetchBrands = async () => {
    //   try {
    //     const response = await axios-get(
    //       `${process.env.NEXT_PUBLIC_API_URL}/api/companies/${user.company_id}/brands`,
    //       {
    //         headers: {
    //           Authorization: `Bearer ${token}`,
    //         },
    //       }
    //     );
    //     setBrands(response.data);
    //     
    //     setFilteredBrand(response.data);
        
    //   } catch (error) {
    //     console.error("Error fetching brands:", error);
     
    //   }
    // };
    const fetchBrands = async () => {
      try {
        const response = await apiRequest(
          `/api/companies/${user.company_id}/brands`,
          'GET'
        );
    
            setBrands(response);
    //     
        setFilteredBrand(response);
      
      } catch (error) {
        console.error("Error fetching brands:", error.message);
  
      
      }
    };
    
    if (user?.company_id) {
      fetchBrands();
    }
  }, []);

  useEffect(() => {
    
  
    if (selectedBrands.length > 0) {
      // Filter visitors based on selected brands
      setFilteredVisitors((prevVisitors) => {
        // Only keep visitors whose public_key is in selectedBrands
        return visitors.filter((visitor) =>
          selectedBrands.includes(visitor.public_key)
        );
      });
    } else {
      // If no brand is selected, reset the filtered visitors to show all visitors
      setFilteredVisitors(visitors);
    }
  }, [selectedBrands,visitors]); // Re-run the effect when selectedBrands or visitors changes
  

  useEffect(() => {
    // Ensure socket instance is created once
    const socketinst = getSocket();
    if (!socketinst) return;

    setSocket(socketinst);
 
    // Emit brand ID to the backend when the page loads
    socketinst.emit("page load", { brand_id: bid });

    const handleActiveVisitors = async (data) => {
      const decryptedData = await decryptData(data);
      
      if (!decryptedData || typeof decryptedData !== "object") {
        console.error("Decryption failed or returned invalid data");
        return;
      }
    
      let {
        client_id,
        public_key,
        join_time,
        unseenMsg,
        served_by,
        landing_url,
        os,
        ip,
        country,
        status,
        visitor_session_id,
        client_name,
        browser,
        brand_name,
        totalMsgCount,
      } = decryptedData;
    
       // Now this should work correctly
    
            //  if (country === 'Pakistan' && !IsShowPK) {

      //   return;
      // }
            const j_time = emitTimeInUserTimezone(join_time);
      // Save the original join_time with client_id
      setOriginalJoinTimes((prevTimes) => ({
        ...prevTimes,
        [client_id]: join_time, // Store the original join time for this client_id
      }));

      const joinDate = new Date(j_time);
      const formattedJoinTime = joinDate.toLocaleTimeString("en-US", {
        hour: "numeric",
        minute: "numeric",
        hour12: true,
      });

      
      
      const newVisitor = {
        name: client_name ? client_name : null,
        client_id: client_id,
        online: joinDate,
        servedBy: served_by,
        viewing: landing_url,
        link: "https://example.com",
        public_key: public_key,
        join_time: formattedJoinTime, // Use formatted join time
        visitorStatus: status,
        visitor_session_id: visitor_session_id,
        os: os,
        ip: ip,
        country: country,
        browser: browser,
        unseenMsg: unseenMsg,
        brand_name: brand_name,
        totalMessages: totalMsgCount,
      };
 
      setVisitors((prevVisitors) => {
      
        // Check if the visitor with the same client_id already exists
        const existingVisitorIndex = prevVisitors.findIndex(
          (v) => v.client_id === client_id
        );
     
        
        if (existingVisitorIndex > -1) {
         
          // Update existing visitor
          const updatedVisitors = [...prevVisitors];
          updatedVisitors[existingVisitorIndex] = newVisitor;
          return updatedVisitors;
        } else {
          // Add new visitor only if it doesn't already exist
          return [...prevVisitors, newVisitor];
        }
      });
      if (selectedBrands.length === 0 || selectedBrands.includes(public_key)) {
      setFilteredVisitors((prevVisitors) => {
      
        // Check if the visitor with the same client_id already exists
        const existingVisitorIndex = prevVisitors.findIndex(
          (v) => v.client_id === client_id
        );
     
        
        if (existingVisitorIndex > -1) {
         
          // Update existing visitor
          const updatedVisitors = [...prevVisitors];
          updatedVisitors[existingVisitorIndex] = newVisitor;
          return updatedVisitors;
        } else {
          // Add new visitor only if it doesn't already exist
          return [...prevVisitors, newVisitor];
        }
      });
    }
    };

    const handleNewClient = (data) => {
      const decryptedData = decryptData(data);
      const {
        client_id,
        client_name,
        public_key,
        brand_name,
        join_time,
        landing_url,
        os,
        ip,
        visitor_session_id,
        country,
        status,
        browser,
      } = decryptedData;
      // if (country === 'Pakistan' && !IsShowPK) {

      //   return;
      // }
      const joinTime = new Date();
      emitTimeInUserTimezone(joinTime);

      // Save the original join_time with client_id
      setOriginalJoinTimes((prevTimes) => ({
        ...prevTimes,
        [client_id]: joinTime, // Store the original join time
      }));

      const joinDate = new Date(joinTime);
      const formattedJoinTime = joinDate.toLocaleTimeString("en-US", {
        hour: "numeric",
        minute: "numeric",
        hour12: true,
      });

      const newVisitor = {
    name: client_name ? client_name : null,
        client_id: client_id,
        online: joinDate,
        servedBy: "",
        viewing: landing_url,
        link: "https://example.com",
        public_key: public_key,
        join_time: formattedJoinTime,
        visitorStatus: status,
        visitor_session_id: decryptedData.visitor_session_id,
        os: os,
        ip: ip,
        country: country,
        browser: browser,
        brand_name: brand_name,
        totalMessages: 0,
      };

      // Update the state with the new visitor
      setVisitors((prevVisitors) => {
 
        const updatedVisitors = [newVisitor, ...prevVisitors];
        // Log inside setState to ensure proper order
        return updatedVisitors;
      });
      
      
      
     
// Determine whether to update filtered visitors
if (selectedBrands.length === 0 || selectedBrands.includes(public_key)) {
  setFilteredVisitors((prevVisitors) => {
    // Only add newVisitor if the public_key is in selectedBrands or selectedBrands is empty
    return [newVisitor, ...prevVisitors];
  });
}

    };

    const handleVisitorServedByUpdate = (data) => {
      const decryptedData = decryptData(data)
      const { client_id, served_by } = decryptedData;
      setVisitors((prevVisitors) => {
    
        return prevVisitors.map((visitor) =>
          visitor.client_id === client_id
            ? { ...visitor, servedBy: served_by }
            : visitor
        );
      });
       
        setFilteredVisitors((prevVisitors) => {
          return prevVisitors.map((visitor) =>
            visitor.client_id === client_id
              ? { ...visitor, servedBy: served_by }
              : visitor
          );
        });
     
    };

    const handleVisitorStatusChange = (data) => {
      const decryptedData = decryptData(data)
      
      const  { client_id, served_by ,status,visitor_id} = decryptedData;
            setVisitors((prevVisitors) => {
              
        if (status === 4) {
          if (currentChat?.client_id == client_id) {
            setHideColumns(false);
            setCurrentChat(null);
          }
          return prevVisitors.filter(
            (visitor) => visitor.client_id !== client_id
          );
        } else {
          // Update visitor's status in the list
          
          
          const updatedVisitors = prevVisitors.map((visitor) =>
            visitor.client_id === client_id
              ? { ...visitor, visitorStatus: status }
              : visitor
          );

          // If the current chat's visitor's status is updated, also update the currentChat state
          if (currentChat?.client_id === client_id) {
            setCurrentChat((prevChat) => ({
              ...prevChat,
              visitorStatus: status,
            }));
          }

          return updatedVisitors;
        }
      });
 
        setFilteredVisitors((prevVisitors) => {
          
    if (status === 4) {
      if (currentChat?.client_id == client_id) {
        setHideColumns(false);
        setCurrentChat(null);
      }
      return prevVisitors.filter(
        (visitor) => visitor.client_id !== client_id
      );
    } else {
      // Update visitor's status in the list
      
      
      const updatedVisitors = prevVisitors.map((visitor) =>
        visitor.client_id === client_id
          ? { ...visitor, visitorStatus: status }
          : visitor
      );

      // If the current chat's visitor's status is updated, also update the currentChat state
      if (currentChat?.client_id === client_id) {
        setCurrentChat((prevChat) => ({
          ...prevChat,
          visitorStatus: status,
        }));
      }

      return updatedVisitors;
    }
  });
       
    };
    const playNotificationSound = () => {
      const audio = new Audio(notificationSound);
      audio.play().catch((err) => console.error("Error playing sound:", err));
    };

    const handleNewMessageBlink = (data) => {
      
      const decryptedData = decryptData(data)
      const message = decryptedData
      
      
 
                  setVisitors((prevVisitors) => {
                    
        return prevVisitors.map((visitor) =>
          visitor.client_id === message.client_id
            ? { ...visitor, totalMessages: message.totalMessages }
            : visitor
        );
      });            setFilteredVisitors((prevVisitors) => {
                    
        return prevVisitors.map((visitor) =>
          visitor.client_id === message.client_id
            ? { ...visitor, totalMessages: message.totalMessages }
            : visitor
        );
      });
      
      // if(message.public_key != brand_pk){
      //   return null;
      // }
      if (message.isParticipant) {
        // playNotificationSound();
      }
  // If notifyAllAdmins is false, check if userId exists in unseenCounts
  if (!message.notifyAllAdmins && !message.unseenCounts.hasOwnProperty(user.userId)) {
    // 
    return;
}
      // Only add to blinking state if the current chat is NOT the one receiving the message
      if (activeTab || activeTab !== message.client_id) {
        
        
        setVisitors((prevVisitors) => {
          
          return prevVisitors.map((visitor) =>
            visitor.client_id === message.client_id
              ? { ...visitor, unseenMsg: message.unseenCount }
              : visitor
          );
        });  setFilteredVisitors((prevVisitors) => {
          
          return prevVisitors.map((visitor) =>
            visitor.client_id === message.client_id
              ? { ...visitor, unseenMsg: message.unseenCount }
              : visitor
          );
        });
        setBlinkingVisitor((prevBlinkingVisitors) => {
          if (!prevBlinkingVisitors.includes(message.client_id)) {
            return [...prevBlinkingVisitors, message.client_id];
          }
          return prevBlinkingVisitors;
        });
      } else {
        
        // If current chat is the same as the message client, we can remove blinking
        removeBlinkingVisitor(message.client_id);
      }
    };
    const handleClientDataUpdate = (data) => {
      const decryptedData = decryptData(data)
      const updatedData = decryptedData;
      
      const { client_id, name, email, phone, notes, tags } = updatedData;
      setVisitors((prevVisitors) => {
        
          // Update visitor's status in the list
          const updatedVisitors = prevVisitors.map((visitor) =>
            visitor.client_id === client_id
              ? { ...visitor, name: name }
              : visitor
          );

          return updatedVisitors;
      });
      setFilteredVisitors((prevVisitors) => {
        
          // Update visitor's status in the list
          const updatedVisitors = prevVisitors.map((visitor) =>
            visitor.client_id === client_id
              ? { ...visitor, name: name }
              : visitor
          );

          return updatedVisitors;
      });
     
      
     
    };
    const handleMessageSeen = (data) => {
      const decryptedData = decryptData(data)
      if(decryptedData.user_id != user.userId){
        return null;
      }
      const message = decryptedData
            setVisitors((prevVisitors) =>
        prevVisitors.map((visitor) =>
          visitor.client_id === message.client_id
            ? { ...visitor, unseenMsg: 0 }
            : visitor
        )
      );    setFilteredVisitors((prevVisitors) =>
        prevVisitors.map((visitor) =>
          visitor.client_id === message.client_id
            ? { ...visitor, unseenMsg: 0 }
            : visitor
        )
      );
    };

    const handleChatMessage = (message) => {
      // const decryptedData = decryptData(data)
      // const message = decryptedData
       
        
       
                  if (activeTab || activeTab !== message.client_id) {
        // Play sound
        // const audio = new Audio(notificationSound); // Adjust the path if necessary
        // audio.play().catch(err => {
        //   console.error("Error playing sound:", err);
        // });

        // Update messages state
        setMessages((prevMessages) => [...prevMessages, message]);
      }
    };

    // Attach event listeners
    socketinst.on("active visitors", handleActiveVisitors);
    socketinst.on("new client", handleNewClient);
    socketinst.on("visitor served by update", handleVisitorServedByUpdate);
    socketinst.on("visitor status change", handleVisitorStatusChange);
    socketinst.on("chat message", handleChatMessage);
    socketinst.on("New message blink", handleNewMessageBlink);
    socketinst.on('client data updated', handleClientDataUpdate);
    socketinst.on("message_seen", handleMessageSeen);
    socketinst.on("visitor_already_left", (data) => {
  const decryptedData = decryptData(data)

      customOnClick();
    });

    return () => {
      // Clean up event listeners
      socketinst.off("active visitors", handleActiveVisitors);
      socketinst.off("new client", handleNewClient);
      socketinst.off("visitor served by update", handleVisitorServedByUpdate);
      socketinst.off("visitor status change", handleVisitorStatusChange);
      socketinst.off("New message blink", handleNewMessageBlink);
      socketinst.off("chat message", handleChatMessage);
      socketinst.off('client data updated', handleClientDataUpdate);
      socketinst.off("message_seen", handleMessageSeen);
      // socketinst.off('chat message', handleChatMessage);
    };
  }, []);
  const customOnClick = () => {
    setShowAlert(true);
    setTimeout(() => {
      setShowAlert(false);
    }, 3000);
  };
  const handleVisitorClick = (visitor) => {
  
    if (activeTab && activeTab === visitor.client_id) {
      setHideColumns(false);
      dispatch(minimize({ client_id: activeTab }));
      socket.emit("stop typing admin", {
        chatKey: `${visitor.public_key}_${visitor.client_id}`,
        from: user?.pseudonym,
      });
  
      socket.emit("admin_closed_chat", {
        client_id: visitor.client_id,
        public_key: visitor.public_key,
        pseudonym: user.pseudonym,
        user_id: user.userId,
      });
      setCurrentChat(null);
    } else {
      if (activeTab) {
        setHideColumns(false);
        dispatch(minimize({ client_id: activeTab }));
      }
  
      // Create a new copy of the visitor object
      const updatedVisitor = {
        ...visitor,
        pseudonym: user.pseudonym,
        userId: user.userId,
      };
      // Remove `online` and `join_time` properties from the new copy
      const visitorCopy = { ...updatedVisitor };
      delete visitorCopy.online;
      delete visitorCopy.join_time;
      
      setCurrentChat(updatedVisitor);
  
  
      socket.emit("join chat", updatedVisitor);
  
      let updatedVi = { ...visitorCopy }; // Clone the visitorCopy object
      
  
      if (visitor.servedBy) {
        updatedVi = {
          ...updatedVi, // Keep existing visitor data
          servedBy: true, // Add/Update servedBy flag
        };
      } else {
        updatedVi = {
          ...updatedVi, // Keep existing visitor data
          servedBy: false, // Add/Update servedBy flag
        };
      }
  
      // Dispatch action to add the updated tab in the Redux store
      dispatch(addTab(updatedVi));
  
      setHideColumns(true);
    }
  };
  

  const handleVisitorNameClick = () => {
    setHideColumns(!hideColumns);
  };

  const copyChatId = (e) => {
    // Assuming the visitor ID is in the previous sibling element to the button
    const visitorIdElement = e.target.closest("button").previousElementSibling;
    if (visitorIdElement) {
      const visitorId = visitorIdElement.textContent;
      navigator.clipboard
        .writeText(visitorId)
        .then(() => {
          setShowToast(true); // Show a success message or toast
          setTimeout(() => setShowToast(false), 2000); // Hide the toast after 2 seconds
        })
        .catch((err) => console.error("Failed to copy text: ", err));
    } else {
      console.error("Visitor ID element not found");
    }
  };

  const handleShowPkChange = (e) => {
        setIsShowPK(e.target.checked);
  };

  // Categorize visitors, adding "Not Served" category
  const categorizedVisitors = {
    active: filteredVisitors.filter(
      (v) => (v.visitorStatus === 1 || v.visitorStatus === 5) && v.servedBy
    ), // Exclude not served
    notServed: filteredVisitors.filter((v) => !v.servedBy), // New category for visitors not served
    idle: filteredVisitors.filter((v) => v.visitorStatus === 2 && v.servedBy), // Exclude not served from idle
    closed: filteredVisitors.filter((v) => v.visitorStatus === 3 && v.servedBy), // Exclude not served from closed
  };
  const noVisitorsFound = Object.values(categorizedVisitors).every(
    (category) => category.length === 0
  );
  const [collapsedSections, setCollapsedSections] = useState({
    active: false,
    notServed: false,
    closed: false,
    idle: false,
  });
  const countPakistaniVisitors = () => {
    const counts = {
      active: categorizedVisitors.active.filter(
        (visitor) => visitor.country === "Pakistan"
      ).length,
      notServed: categorizedVisitors.notServed.filter(
        (visitor) => visitor.country === "Pakistan"
      ).length,
      idle: categorizedVisitors.idle.filter(
        (visitor) => visitor.country === "Pakistan"
      ).length,
      closed: categorizedVisitors.closed.filter(
        (visitor) => visitor.country === "Pakistan"
      ).length,
    };
    return counts;
  };

  const pakistaniVisitorCounts = countPakistaniVisitors();
  const toggleSection = (section) => {
    setCollapsedSections((prev) => ({
      ...prev,
      [section]: !prev[section],
    }));
  };
  // Map selected brand keys to their names
  const selectedBrandNames = brands
    .filter((brand) => selectedBrands.includes(brand.public_key))
    .map((brand) => brand.name);

  return (
    <>
      {showToast && (
        <div
          className="toast show alert-success  "
          role="alert"
          aria-live="assertive"
          aria-atomic="true"
        >
          <div className="alert alert-success alert-on-chat " role="alert">
            Visitor ID copied to clipboard!
          </div>
        </div>
      )}
      {ShowAlert && (
        <div
          className="toast show alert-danger  "
          role="alert"
          aria-live="assertive"
          aria-atomic="true"
        >
          <div className="alert alert-danger alert-on-chat " role="alert">
            Visitor may have left..
          </div>
        </div>
      )}

      <div className="container-fluid top-bar">
        <div className="left-div chat-left-div-top">
          <h2>Visitors</h2>
          <div className="box-show-pk">
            <label>
              Show PK
              <input
                type="checkbox"
                value={"Show PK"}
                id="show_pk"
                onChange={handleShowPkChange}
                className="show_pk"
                placeholder="Show Pk"
              />
            </label>
          </div>
        </div>
        <div className="right-div"></div>
      </div>
      <div className="container-fluid company-header">
      <div className="comp-header-row chat-header">
        <button className="btn me-2" onClick={toggleFilterChats}>
          Filter
        </button>
        {selectedBrandNames.length > 0 && (
          <div className="selected-brands">
            {selectedBrandNames.map((name, index) => (
              <span key={index} className="chat-brand-name">
                {name}
              </span>
            ))}
          </div>
        )}
      </div>

      <div
        className={`chat-filter-wrapper ${
          showFilter ? "show" : "hide"
        }`}
      >
        <FilterChats onClose={toggleFilterChats}  setBrands={setBrands} brands={brands} setFilteredBrands={setFilteredBrand} filteredBrands={filteredBrand}  />
      </div>
    </div>
      <div
        className={`chat-visitor-container ${activeTab ? "half-width" : ""}`}
      >
         {noVisitorsFound ? (
        <div className="no-visitor-found">
          <h3>No visitor found.</h3>
        </div>
      ) :(
        <div
          className={`chat-main-content mt-3 ${
            activeTab ? "half-width" : ""
          }`}
        >
          {categorizedVisitors.active.length > 0 && (
            <>
              <h3 onClick={() => toggleSection("active")} className="collapsible-header">
                Active Visitors{" "}
                (
                {IsShowPK
                  ? categorizedVisitors.active.length
                  : categorizedVisitors.active.length -
                    categorizedVisitors.active.filter(
                      (visitor) => visitor.country === "Pakistan"
                    ).length}
                )
                <span> {" "}{collapsedSections.active ? "+" : "-"}</span>
              </h3>
      
              {!collapsedSections.active && (
                <VisitorTable
                  visitors={categorizedVisitors.active}
                  copyChatId={copyChatId}
                  onVisitorNameClick={handleVisitorClick}
                  hideColumns={hideColumns}
                  blinkingVisitor={blinkingVisitor}
                  copyVisitorId={copyVisitorId}
                  type="active_visitor_chat"
                  IsShowPK={IsShowPK}
                />
              )}
            </>
          )}
      
          {categorizedVisitors.notServed.length > 0 && (
            <>
              <h3
                onClick={() => toggleSection("notServed")}
                className="collapsible-header mt-3"
              >
                Not Served Visitors{" "}
                (
                {IsShowPK
                  ? categorizedVisitors.notServed.length
                  : categorizedVisitors.notServed.length -
                    categorizedVisitors.notServed.filter(
                      (visitor) => visitor.country === "Pakistan"
                    ).length}
                )
                <span> {" "}{collapsedSections.notServed ? "+" : "-"}</span>
              </h3>
              {!collapsedSections.notServed && (
                <VisitorTable
                  visitors={categorizedVisitors.notServed}
                  copyChatId={copyChatId}
                  onVisitorNameClick={handleVisitorClick}
                  hideColumns={hideColumns}
                  blinkingVisitor={blinkingVisitor}
                  copyVisitorId={copyVisitorId}
                  IsShowPK={IsShowPK}
                  type="note_served"
                />
              )}
            </>
          )}
      
          {categorizedVisitors.closed.length > 0 && (
            <>
              <h3
                onClick={() => toggleSection("closed")}
                className="collapsible-header mt-3"
              >
                Closed Chats{" "}
                (
                {IsShowPK
                  ? categorizedVisitors.closed.length
                  : categorizedVisitors.closed.length -
                    categorizedVisitors.closed.filter(
                      (visitor) => visitor.country === "Pakistan"
                    ).length}
                )
                <span> {" "}{collapsedSections.closed ? "+" : "-"}</span>
              </h3>
              {!collapsedSections.closed && (
                <VisitorTable
                  visitors={categorizedVisitors.closed}
                  copyChatId={copyChatId}
                  onVisitorNameClick={handleVisitorClick}
                  hideColumns={hideColumns}
                  blinkingVisitor={blinkingVisitor}
                  copyVisitorId={copyVisitorId}
                  type="closed_chat_visitor"
                  IsShowPK={IsShowPK}
                />
              )}
            </>
          )}
      
          {categorizedVisitors.idle.length > 0 && (
            <>
              <h3
                onClick={() => toggleSection("idle")}
                className="collapsible-header mt-3"
              >
                Idle Visitors{" "}
                (
                {IsShowPK
                  ? categorizedVisitors.idle.length
                  : categorizedVisitors.idle.length -
                    categorizedVisitors.idle.filter(
                      (visitor) => visitor.country === "Pakistan"
                    ).length}
                )
                <span> {" "}{collapsedSections.idle ? "+" : "-"}</span>
              </h3>
              {!collapsedSections.idle && (
                <VisitorTable
                  visitors={categorizedVisitors.idle}
                  copyChatId={copyChatId}
                  onVisitorNameClick={handleVisitorClick}
                  hideColumns={hideColumns}
                  blinkingVisitor={blinkingVisitor}
                  copyVisitorId={copyVisitorId}
                  type="idle_visitor_chat"
                  IsShowPK={IsShowPK}
                />
              )}
            </>
          )}
        </div>
      )
      
      }

        {/* {hideColumns && <ChatVisitor currentChat={currentChat} setHideColumns={setHideColumns}  setCurrentChat={setCurrentChat} originalJoinTimes={originalJoinTimes} />} */}
      </div>
    </>
  );
};

const VisitorTable = ({
  visitors,
  copyChatId,
  onVisitorNameClick,
  hideColumns,
  blinkingVisitor,
  copyVisitorId,
  type,
  IsShowPK,
}) => {
  const {  activeTab } = useSelector((state) => state.chat);
 
  return (
    <table className="chat-stats-table">
      <thead className={`${type}`}>
        <tr>
          <th></th>
          <th>Visitor</th>
          <th>Platform</th>
          <th>Messages</th>
          <th>Duration</th>
          <th>Served by</th>
          {/* <th className={hideColumns ? 'd-none' : ''}>Served by</th> */}
          <th>Brand</th>
          <th
            className={
              activeTab ? "d-none inActive_feature" : "inActive_feature"
            }
          >
            Landing Page
          </th>
        </tr>
      </thead>
      <tbody>
        
        {visitors.map((visitor, index) => (
          <VisitorRow
            key={index}
            name={visitor.name}
            brand_name={visitor.brand_name}
            chatId={visitor.client_id}
            visitorStatus={visitor.visitorStatus}
            visitor={visitor}
            online={visitor.online}
            servedBy={visitor.servedBy}
            unseenMsg={visitor.unseenMsg}
            viewing={visitor.viewing}
            link={visitor.link}
            copyChatId={copyChatId}
            onVisitorNameClick={onVisitorNameClick}
            hideColumns={hideColumns}
            blinkingVisitor={blinkingVisitor}
            copyVisitorId={copyVisitorId} // Add this line to update the toast message on successful copy
            totalMessages={visitor.totalMessages}
            IsShowPK={IsShowPK}
            join_time={visitor.join_time}
          />
        ))}
      </tbody>
    </table>
  );
};

const VisitorRow = ({
  name,
  brand_name,
  chatId,
  visitor,
  online,
  servedBy,
  unseenMsg,
  viewing,
  link,
  copyChatId,
  onVisitorNameClick,
  hideColumns,
  visitorStatus,
  blinkingVisitor,
  copyVisitorId,
  totalMessages,
  IsShowPK,
  join_time,
}) => {
  const [onlineTime, setOnlineTime] = useState("");
   
  // Calculate the online time based on the joinTime
  const calculateOnlineTime = useCallback(() => {
    const now = new Date();
   
    
    const onlineDate = online && Number(online) > 0 ? new Date(online) : now;
    const diffMs = now - new Date(onlineDate);
    const diffMins = Math.floor(diffMs / (1000 * 60));
    const diffHrs = Math.floor(diffMins / 60);
    const remainingMins = diffMins % 60;
    
    return `${diffHrs > 0 ? diffHrs + "h " : ""}${remainingMins}m`;
  }, [online]);

  // Use `useMemo` to calculate the initial `onlineTime` and prevent unnecessary re-renders
  const initialOnlineTime = useMemo(
    () => calculateOnlineTime(),
    [calculateOnlineTime]
  );

  useEffect(() => {
    setOnlineTime(initialOnlineTime);

    // Update online time every 15 seconds only if it has changed
    const interval = setInterval(() => {
      const newOnlineTime = calculateOnlineTime();
      setOnlineTime((prev) => (prev !== newOnlineTime ? newOnlineTime : prev));
    }, 15 * 1000);

    return () => clearInterval(interval);
  }, [calculateOnlineTime, initialOnlineTime]);



  // Helper to get browser name
  const getBrowserName = (browser) => {
    if (browser?.includes("Chrome")) {
      return "chrome";
    } else if (browser?.includes("Firefox")) {
      return "firefox";
    } else if (browser?.includes("Safari") && !browser?.includes("Chrome")) {
      return "safari";
    } else if (browser?.includes("Edge")) {
      return "edge";
    } else if (browser?.includes("Trident")) {
      return "ie";
    }
    return "unknown";
  };
  // Helper to get browser icon as an image
  const getBrowserIcon = (browser) => {
    let brows = getBrowserName(browser);
    switch (brows?.toLowerCase()) {
      case "chrome":
        return <img src={chrome.src} className="browser-icon" alt="chrome" />;
      case "firefox":
        return <img src={firefox.src} className="browser-icon" alt="firefox" />;
      case "safari":
        return <img src={safari.src} className="browser-icon" alt="safari" />;
      case "edge":
        return <img src={edge.src} className="browser-icon" alt="edge" />;
      case "ie":
        return <img src={edge.src} className="browser-icon" alt="edge" />;
      default:
        return null;
    }
  };

  // Helper to get OS icon as an image
  const getOSIcon = (os) => {
    switch (os?.toLowerCase()) {
      case "windows":
        return <img src={windows.src} alt="Windows" className="os-icon" />;

      case "mac":
      case "macos":
      case "apple":
        return <img src={Ios.src} alt="Apple" className="os-icon" />;

      case "linux":
        return <img src={ubunto.src} alt="Linux" className="os-icon" />;

      case "android":
        return <img src={android.src} alt="Android" className="os-icon" />;

      case "ios":
      case "iphone":
      case "ipad":
        return <img src={Ios.src} alt="iOS" className="os-icon" />;

      case "unix":
        return (
          <img
            src="https://upload.wikimedia.org/wikipedia/commons/thumb/3/35/Tux.svg/1200px-Tux.svg.png"
            alt="UNIX"
            className="os-icon"
          />
        );

      default:
        return null;
    }
  };

  // Helper to get country flag as an image

  const currentVisitorData = blinkingVisitor.find(
    (v) => v.client_id === visitor.client_id
  );
  const unseenCount = currentVisitorData ? currentVisitorData.unseenCount : 0;

  // Helper to get country flag
  const getCountryFlag = (country) => {
    const countryCode = countryNameToCode[country];
    return countryCode ? (
      <img
        src={`https://flagcdn.com/80x60/${countryCode}.png`}
        alt={`${country} flag`}
        width="24"
        height="18"
      />
    ) : null;
  };

  const {   activeTab } = useSelector((state) => state.chat);
  return (
    <tr
      className={`${unseenMsg > 0 ? "new-message-blink-row":""}   visitor-row-new ${
        visitor?.country === "Pakistan" && !IsShowPK
          ? "hide-pakistan-visitors"
          : ""
      }   
    ${activeTab === chatId ? "active-history-row" : ""} `}
    onClick={() => onVisitorNameClick(visitor)}
    >
     
      {visitor?.country === "Pakistan" && !IsShowPK}

      <td>
        <div
          className={`chat-icon-visitor ${
            visitorStatus == 2 ? "visitor-idle" : ""
          }  ${visitorStatus == 5 ? "visitor-non-active" : ""}  ${
            servedBy?.length > 0 ? "visitor-served" : "visitor-not-served"
          }  ${visitorStatus == 3 ? "visitor-close-chat" : ""} `}
        >
          {}
          {unseenMsg > 0 && (
            <div className="newMessageNoti">
              {unseenMsg > 0 ? unseenMsg : ""}
            </div>
          )}
          <img src="/assets/images/chat-icon.png" alt="Chat Icon" />
        </div>
      </td>
      <td>
        <h4 className="pointer visitor-name">{name ? name : `${chatId}`}</h4>
        {/* <div className={`chat-id ${servedBy?.length > 0 ? 'visitor-served' : 'visitor-not-served'}  ${visitorStatus==5?'visitor-non-active':''} ${visitorStatus === 2 ? 'visitor-idle' : ''} ${visitorStatus === 3 ? 'visitor-close-chat' : ''}`}>

        Visitor ID:
        <button onClick={(event) => copyVisitorId(visitor.client_id, event)}>Copy </button>
      </div> */}
      </td>
      <td className="browser-info">
        {/* Browser Icon with Tooltip */}
        <div className="tooltip">
          {getBrowserIcon(visitor?.browser)}
          <span className="tooltiptext">
            Browser: {visitor?.browser}
            <div className="tooltip-arrow"></div>
          </span>
        </div>

        {/* OS Icon with Tooltip */}
        <div className="tooltip">
          {getOSIcon(visitor?.os)}
          <span className="tooltiptext">
            OS: {visitor?.os}
            <div className="tooltip-arrow"></div>
          </span>
        </div>

        {/* Country Flag with Tooltip */}
        <div className="tooltip">
          {getCountryFlag(visitor?.country)}
          <span className="tooltiptext">
            Country: {visitor?.country}
            <div className="tooltip-arrow"></div>
          </span>
        </div>
      </td>

      <td>{totalMessages}</td>

      <td>
        {visitorStatus == 1 || 5
          ? onlineTime
          : visitorStatus == 2
          ? "idle"
          : visitorStatus == 3
          ? "close chat"
          : ""}
      </td>

      <td>{servedBy}</td>
      <td data-title={viewing} className="brand-tooltip">
  {brand_name}
</td>


      {/* <td className={activeTab ? 'd-none' : ''} >{servedBy}</td>
     <td className={activeTab ? 'd-none' : ''} >{brand_name}</td> */}
      <td
        className={
          activeTab
            ? "d-none inActive_feature"
            : "visitor-landed-on inActive_feature"
        }
      >
        {viewing}
      </td>
    </tr>
  );
};
 
export default Chat;
 