import React, { useState, useEffect } from 'react';
import { FaArrowAltCircleRight } from 'react-icons/fa';
import { getSocket } from '@/app/lib/socketManager';

const VisitorDetails = ({ clientId, publicKey ,currentChat ,originalJoinTimes ,setHideColumns ,setCurrentChat}) => {
 
 
  const socket = getSocket();
  const [VisitedUrl, setVisitedUrl] = useState([])
  const [MetadataV, setMetadataV]=useState()
  const joinTime = originalJoinTimes[clientId]; // Fetch original join time by clientId
  const [visitorData, setVisitorData] = useState({
    name: '',
    email: '',
    phone: '',
    notes: '',
    tags: [],
    tagInput: '', // To track the input while typing tags
  });
  const [elapsedTime, setElapsedTime] = useState('0 mins');
  useEffect(() => {
    const updateElapsedTime = () => {
      if (joinTime) {
        
        
        const now = new Date();
        const joinDate = new Date(joinTime); // Use the original join time as a Date object

        const diff = now - joinDate;
        const secondsElapsed = Math.floor(diff / 1000); // Calculate seconds
        const minutesElapsed = Math.floor(secondsElapsed / 60); // Calculate minutes
        const hoursElapsed = Math.floor(minutesElapsed / 60); // Calculate hours

        const displayMinutes = minutesElapsed % 60; // Remaining minutes
        const displaySeconds = secondsElapsed % 60; // Remaining seconds

        let timeString = '';

        if (hoursElapsed > 0) {
          timeString = `${hoursElapsed} hr ${displayMinutes} : ${displaySeconds} `;
        } else if (minutesElapsed > 0) {
          timeString = `${displayMinutes} : ${displaySeconds} `;
        } else {
          timeString = `${displaySeconds} sec`;
        }

        setElapsedTime(timeString);
      }
    };

    updateElapsedTime();
    const interval = setInterval(updateElapsedTime, 1000); // Update every second

    return () => clearInterval(interval); // Clean up interval on component unmount
  }, [joinTime]);

 // Function to check and trim URL
function checkAndTrimUrl(url) {
  if (url.length > 32) {
    // Trim the URL if its length exceeds the reference URL length
    return url.substring(0, 32) + "...";
  }
  return url;
}
    // Fetch client data and handle socket events
    useEffect(() => {
      const fetchClientData = async () => {
        try {
          const response = await fetch(`${process.env.NEXT_PUBLIC_API_URL}/api/client/data`, {
            method: 'POST',
            headers: {
              'Content-Type': 'application/json',
            },
            body: JSON.stringify({ chatKey: `${currentChat?.public_key}_${currentChat?.client_id}` }),
          });
          if (!response.ok) {
            throw new Error('Failed to fetch client data');
          }
          const data = await response.json();
          const { name, email, phone, notes, tags } = data.client;
  
          setVisitorData({
            name: name || '',
            email: email || '',
            phone: phone || '',
            notes: notes || '',
            tags: tags || [],
            tagInput: '',
          });
        } catch (error) {
          console.error('Error fetching client data:', error);
        }
      };
  
      if (currentChat) {
        fetchClientData(); // Call the function to fetch data
      }
    }, [currentChat]);
  
    // Handle socket events (only once)
    useEffect(() => {
      const handleUrlUpdate = (data) => {
        
        
        
        
        if(currentChat.client_id == data.clientId){
     
        setVisitedUrl((prevVisitedUrl) => [
          data.url,
          ...prevVisitedUrl,
        ]);
           
      }
      };

  
      const handleClientDataUpdate = (updatedData) => {
        const { name, email, phone, notes, tags } = updatedData;
        setVisitorData((prevData) => ({
          ...prevData,
          name,
          email,
          phone,
          notes,
          tags: tags || [],
        }));
      };
  
      socket.on('visitor url update', handleUrlUpdate);
      socket.on('client data updated', handleClientDataUpdate);
  
      // Clean up socket listeners on unmount
      return () => {
        socket.off('visitor url update', handleUrlUpdate);
        socket.off('client data updated', handleClientDataUpdate);
      };
    }, [socket]);
    const fetchVisitedUrls = async () => {
      try {
        const response = await fetch(`${process.env.NEXT_PUBLIC_API_URL}/api/client/${clientId}/urls`);
        if (!response.ok) {
          throw new Error('Failed to fetch visited URLs');
        }
        const data = await response.json();
        const extractedUrls = data.urls.map((item) => item.url);
        setVisitedUrl(extractedUrls);
      } catch (error) {
        console.error('Error fetching visited URLs:', error);
      }
    };
     const fetchVisitorMetada = async () => {
      try {
        const response = await fetch(`${process.env.NEXT_PUBLIC_API_URL}/api/client/client-metadata/${clientId}`);
        if (!response.ok) {
          throw new Error('Failed to fetch visitor metadata');
        }
        const data = await response.json();
        setMetadataV(data)
        
        
      } catch (error) {
        console.error('Error fetching visitor metadata:', error);
      }
    };
    // Fetch visited URLs when the component mounts or `clientId` changes
    useEffect(() => {
    
  
      if (clientId) {
        fetchVisitedUrls();
        fetchVisitorMetada();
      }
    }, [clientId]);
  
  const handleInputChange = (e) => {
    const { id, value } = e.target;
    setVisitorData((prevData) => ({
      ...prevData,
      [id]: value,
    }));
  };

  const handleTagInputChange = (e) => {
    const { value } = e.target;
    // If the input contains a comma or space, add the tag
    if ( value.endsWith(', ') ||  e.key === 'Enter') {
      const newTag = value.trim().replace(',', '');
      if (newTag && !visitorData.tags.includes(newTag)) {
        setVisitorData((prevData) => ({
          ...prevData,
          tags: [...prevData.tags, newTag],
          tagInput: '',
        }));
      } else {
        setVisitorData((prevData) => ({
          ...prevData,
          tagInput: '',
        }));
      }
    } else {
      setVisitorData((prevData) => ({
        ...prevData,
        tagInput: value,
      }));
    }
  };
// Handle key press for Enter
const handleTagKeyPress = (e) => {
  if (e.key === 'Enter') {
    e.preventDefault(); // Prevent default form submission or action when pressing Enter
    handleTagInputChange(e); // Call the input change handler on Enter
  }
};
const removeTag = (indexToRemove) => {
  setVisitorData((prevData) => {
    const updatedTags = prevData.tags.filter((_, index) => index !== indexToRemove);
    
    // Update the tags in state
    const updatedData = {
      ...prevData,
      tags: updatedTags,
    };
    
    // Emit the updated data using the same event
    socket.emit('update client data', {
      client_id: clientId,
      public_key: publicKey,
      ...updatedData,
    });

    return updatedData; // Update the state with filtered tags
  });
};


  const handleUpdateVisitorData = () => {
    const updatedData = {
      ...visitorData,
      tags: visitorData.tags, // Already an array of tags
    };

    socket.emit('update client data', {
      client_id: clientId,
      public_key: publicKey,
      ...updatedData,
    });

    
  };
  const handleCloseChat = ()=>{
    socket.emit('admin_closed_chat',{
      client_id: clientId,
      public_key: publicKey,
      pseudonym: currentChat.pseudonym,
      user_id: currentChat.userId

    })
    setHideColumns(false)
    setCurrentChat(null)
  }

  return (
    <div className="visitor-box-right">
      <div className='closed-chatbox-sidebar' onClick={handleCloseChat}>x</div>
      <div className="client-details-box chat-visitor-item-3">
        <div className="input-group">
          <input
            type="text"
            id="name"
            className="visitor-name-input form-control"
            placeholder="Add Name"
            value={visitorData.name}
            onChange={handleInputChange}
            onBlur={handleUpdateVisitorData}
          />
        </div>
        <div className="input-group">
          <input
            type="email"
            id="email"
            className="visitor-email-input form-control"
            placeholder="Add Email"
            value={visitorData.email}
            onChange={handleInputChange}
            onBlur={handleUpdateVisitorData}
          />
        </div>
        <div className="input-group">
          <input
            type="tel"
            id="phone"
            className="visitor-phone-input form-control"
            placeholder="Add Phone Number"
            value={visitorData.phone}
            onChange={handleInputChange}
            onBlur={handleUpdateVisitorData}
          />
        </div>
        <div className="input-group">
          <textarea
            id="notes"
            className="visitor-notes-textarea form-control"
            rows="3"
            placeholder="Add Visitor Notes"
            value={visitorData.notes}
            onChange={handleInputChange}
            onBlur={handleUpdateVisitorData}
          ></textarea>
        </div>

        {/* Tag Input Section */}
        <div className="input-group d-flex flex-column">
          <label htmlFor="tags" style={{ fontSize: '13px' }}>Tags:</label>
          <div className="tags-input-container">
          <div className={`tags-box-container ${visitorData.tags.length ? 'active' : ''}`}>
            {visitorData.tags.map((tag, index) => (

              <div className="tag-item "  key={index}>
                <span className="tag-text">{tag}</span>
                <span className="tag-remove" onClick={() => removeTag(index)}>
                  &times;
                </span>
              </div>
            ))}
            </div>
            <input
              type="text"
              id="tagInput"
              className="visitor-tags-input form-control w-100"
              placeholder="Add Tags (comma + space or enter to create)"
              value={visitorData.tagInput}
              onChange={handleTagInputChange}
              onBlur={handleUpdateVisitorData}
              onKeyPress={handleTagKeyPress}
            />
          </div>
        </div>
      </div>
 {/* Client Visit Stats Box */}
 <div className="client-visit-stats-box chat-visitor-item-4">
        <div className="client-stats-head">
          <div className="past-visits-stats chat-stats">
            <p>{MetadataV?.total_visitor_sessions}</p>
            <span>Past Visits</span>
          </div>
          <div className="past-chats-stats chat-stats">
            <p>{MetadataV?.total_chat_sessions}</p>
            <span>Past Chats</span>
          </div>
       
          <div className="past-timing-stats chat-stats">
          <p>{elapsedTime}</p>
          <span>Time on site</span>
        </div>
      </div>
        <div className="visitor-path mt-3" style={{ background: '#fff' }}>
          <h4 style={{ fontSize: '17px', fontWeight: 'bold' }}>Visitor Path</h4>
          <div className="visitor-path-list">
            <ul>
             
            {VisitedUrl?.slice().reverse().map((url, index) => (
  <li key={index}>
    <FaArrowAltCircleRight className="me-2" style={{ color: '#72BE9E' }} />
    <a href={url} target='_blank' className='visitor-url-chat'>{checkAndTrimUrl(url)}</a>
  </li>
))}
  
              {/* Additional paths */}
            </ul>
          </div>
        </div>
        <div className="visitor-details-ip">
          <div className="visitor-ip-stats" style={{ background: '#d50606' }}>
            <span>Bad IP</span>
          </div>
          <div className="visitor-location visitor-extra-stats">
            <span>Location: </span>
            <p>
  {MetadataV?.country}
  {MetadataV?.city && MetadataV.city !== 'Unknown' ? `, ${MetadataV.city}` : ''}
</p>

          </div> 
          <div className="visitor-location visitor-extra-stats">
            <span>IP: </span>
            <p>{MetadataV?.ip} </p>
          </div>
          <div className="visitor-browser visitor-extra-stats">
            <span>Browser: </span>
            <p>{MetadataV?.browser}</p>
          </div>
          <div className="visitor-os visitor-extra-stats">
            <span>OS: </span>
            <p>{MetadataV?.os}</p>
          </div>
        </div>
      </div>

      {/* Visitor History Box */}
      <div className="visitor-history-box chat-visitor-item-5">
        {/* Add Visitor History content */}
      </div>
      {/* Remaining UI Components */}
    </div>
  );
};

export default VisitorDetails;
