"use client";
import React, { useEffect, useState } from "react";
import axios from "axios";
import { getCookie } from "cookies-next";
import { useSelector } from "react-redux";
import Link from "next/link";
import apiRequest from "@/app/lib/InterceptorAxios/axios";
import LoadingSkeletonTable from "../loading";

const BrandsPage = () => {
  const [brands, setBrands] = useState([]);
  const [filteredBrands, setFilteredBrands] = useState([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);
  const [searchTerm, setSearchTerm] = useState("");
  const token = getCookie("token");
  const user = useSelector((state) => state.user.userInfo);

  useEffect(() => {
    // const fetchBrands = async () => {
    //   try {
    //     const response = await axios-get(
    //       `${process.env.NEXT_PUBLIC_API_URL}/api/companies/all-brands/sa`,
    //       {
    //         headers: {
    //           Authorization: `Bearer ${token}`,
    //         },
    //       }
    //     );
    //     
    //     setBrands(response.data);
    //     setFilteredBrands(response.data);
    //     setLoading(false);
    //   } catch (error) {
    //     console.error("Error fetching brands:", error);
    //     setError("Failed to fetch brands");
    //     setLoading(false);
    //   }
    // };
    const fetchBrands = async () => {
      try {
        const response = await apiRequest('/api/companies/all-brands/sa', 'GET');
    
        
        setBrands(response);
        setFilteredBrands(response);
        setLoading(false);
      } catch (error) {
        console.error("Error fetching brands:", error.message);
        setError("Failed to fetch brands");
        setLoading(false);
      }
    };
    if (token) {
      fetchBrands();
    }
  }, [token]);

  useEffect(() => {
    const lowercasedSearchTerm = searchTerm.toLowerCase();
    const filtered = brands.filter((brand) =>
      [brand?.brandName, brand?.url, brand?.company]
        .filter(Boolean)
        .some((field) => field.toLowerCase().includes(lowercasedSearchTerm))
    );
    setFilteredBrands(filtered);
  }, [searchTerm, brands]);

  if (loading) {
    return <LoadingSkeletonTable/>;
  }

  if (error) {
    return <div>Error: {error}</div>;
  }

  return (
    <div className="container-fluid table-container table-responsive">
      <h2 className="my-3">Brands</h2>

      <div className="mb-3">
        <input
          type="text"
          className="form-control"
          placeholder="Search by Brand Name, URL, or Company"
          value={searchTerm}
          onChange={(e) => setSearchTerm(e.target.value)}
        />
      </div>

      <table className="table table-striped mt-4">
        <thead>
          <tr>
            <th>Logo</th>
            <th>Brand Name</th>
            <th>URL</th>
            <th>Company</th>
            <th>Phone</th>
            <th>Email</th>
            <th>Status</th>
            <th>Action</th>

          </tr>
        </thead>
        <tbody>
          {filteredBrands.map((brand) => (
            <tr key={brand.brand_id}>
              <td>
                <img
                  src={brand?.logo || "/assets/images/dp.png"}
                  alt={brand?.brandName || "Brand Logo"}
                  width={50}
                  height={50}
                  onError={(e) => (e.target.src = "/assets/images/dp.png")}
                  className="img-thumbnail"
                />
              </td>
              <td>
                <Link
                  href={`company-management/${brand?.company_id}/brands/${brand?.brand_id}`}
                >
                  {brand?.brandName || "N/A"}
                </Link>
              </td>
              <td>
                <a href={brand?.url} target="_blank" rel="noopener noreferrer">
                  {brand?.url || "N/A"}
                </a>
              </td>
              <td>
                <Link href={`company-management/${brand?.company_id}`}>
                  {brand?.company || "N/A"}
                </Link>
              </td>
              <td>{brand?.phone || "N/A"}</td>
              <td>{brand?.email || "N/A"}</td>
              <td>{brand?.status}</td>
              <td className="table-end-buttons">
              <Link prefetch={false} href={`/company-management/${brand?.company_id}/brand-assign-user/${brand.brand_id}`}>
                      <button className="btn btn-sm p-0 text-sm-center py-2 px-1   p-btn w-100 ">Assign User</button>
                    </Link>
              </td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
};

export default BrandsPage;
