import { useState, useEffect } from 'react';
import { MdCheckCircle, MdBlock } from 'react-icons/md';
import apiRequest from '../lib/InterceptorAxios/axios';

const VisitorIpStats = ({ isClientBlocked, isIpBlocked, clientId, ip, pseudonym,socket,public_key }) => {
  const [clientBlocked, setClientBlocked] = useState(isClientBlocked);
  const [ipBlocked, setIpBlocked] = useState(isIpBlocked);
  
  // Sync the state with the incoming props (isClientBlocked, isIpBlocked)
  useEffect(() => {
    setClientBlocked(isClientBlocked);
  }, [isClientBlocked]);

  useEffect(() => {
    setIpBlocked(isIpBlocked);
  }, [isIpBlocked]);

    // Shows prop value
     // Shows state value

  // Function to make the API request to block/unblock IP or client
  const handleBlockUnblock = async (type, value) => {
    try {
      const action = type === 'client' ? (clientBlocked ? 'unblock' : 'block') : (ipBlocked ? 'unblock' : 'block');
     
      
      
      
      socket.emit('blocked_visitor_to_chat',{
        client_id: clientId, // the id of the person performing the action
        pseudonym: pseudonym, // the name of the person performing the action
        public_key:public_key,        // either 'client' or 'ip'
        value: action === 'block'? 1 : 0, // either 1 or 0 for blocking/unblocking
      })
      const data =  await apiRequest("/api/client/change-client-status", "POST", {
        blockValue: value, // either clientId or ip
        pseudonym: pseudonym, // the name of the person performing the action
        type: type,  
      });
      
        if (type === 'client') {
          setClientBlocked(action === 'block');
        } else if (type === 'ip') {
          setIpBlocked(action === 'block');
        }
      
    } catch (error) {
      console.error('Request failed:', error);
    }
  };

  return (
    <div className='d-flex'>
      {/* Client Block/Unblock Button */}
      <button
        onClick={() => handleBlockUnblock('client', clientId)}
         className='chat-visitor-status-btn inActive_feature'
        style={{
          background: clientBlocked ? '#d50606' : 'rgb(15 143 15)',
      
        }}
      >
        
        
          <MdBlock style={{ marginRight: '5px', fontSize: '14px' }} />
       
       Client
      </button>

      {/* IP Block/Unblock Button */}
      <button
        onClick={() => handleBlockUnblock('ip', ip)}
        className='chat-visitor-status-btn inActive_feature'
        style={{
          background: ipBlocked ? '#d50606' : 'rgb(15 143 15)',
            
        }}
      >
      
          <MdBlock style={{ marginRight: '5px', fontSize: '14px' }} />
          {/* Client 950f956e-e313-4a4d-996c-5e5d0a37e44d-vurkflow.com-1726163810502 was blocked by testperson. */}
        IP
      </button>
    </div>
  );
};

export default VisitorIpStats;
